//
// $Id: fmcdrom.cc,v 1.15 2001/07/18 16:13:18 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#include "bochs.h"
#if BX_EMULATION_TOWNS
#define LOG_THIS bx_fmcdrom.


bx_fmcdrom_c bx_fmcdrom;
#if BX_USE_FMCD_SMF
#define this (&bx_fmcdrom)
#endif


bx_fmcdrom_c::bx_fmcdrom_c(void)
{
  setprefix("[FMCD]");
  settype(CDLOG);
}

bx_fmcdrom_c::~bx_fmcdrom_c(void)
{
  // nothing for now
}

static inline int bcd2bin(int in)
{
  return((in&0xf)+((in&0xf0)>>4)*10);
}

static inline int bin2bcd(int in)
{
  return((in%10)|((in/10)<<4));
}

  void
bx_fmcdrom_c::init(bx_devices_c *d)
{
  // FM-TOWNS CDROM

  BX_FMCDROM_THIS devices = d;

  int i;

  static struct {
    Bit16u num;
    Boolean read;
    Boolean write;
  } fmcdrom_ports[]={
    {0x04c0,1,1},
    {0x04c2,1,1},
    {0x04c4,1,1},
    {0x04c6,0,1},
    {0x04cc,1,0},
    {0x04cd,1,0},
    {0,0,0}
  };

  BX_FMCDROM_THIS devices->register_irq(9, "FM-TOWNS CD-ROM");
  i=0;
  while(fmcdrom_ports[i].num!=0) {
    if(fmcdrom_ports[i].read) {
      BX_FMCDROM_THIS devices->register_io_read_handler(this, read_handler,
							 fmcdrom_ports[i].num,
							 "FM-TOWNS CD-ROM");
    }
    if(fmcdrom_ports[i].write) {
      BX_FMCDROM_THIS devices->register_io_write_handler(this, write_handler,
							  fmcdrom_ports[i].num,
							  "FM-TOWNS CD-qROM");
    }
    i++;
  }

  BX_FMCDROM_THIS timer_handle = bx_pc_system.register_timer(this,
							     timer_handler,
							     100,
							     0,
							     0);

  BX_FMCDROM_THIS ready=1;
  BX_FMCDROM_THIS indisc=0;
  BX_FMCDROM_THIS readindex=-1;

  if (bx_options.cdromd.present) {
#ifdef LOWLEVEL_CDROM
	BX_FMCDROM_THIS cd = new LOWLEVEL_CDROM(bx_options.cdromd.dev);
	if (bx_options.cdromd.inserted) {
	      if (BX_FMCDROM_THIS cd->insert_cdrom()) {
		    BX_INFO(("Media present in CD-ROM drive\n"));
		    BX_FMCDROM_THIS indisc=1;
		    BX_FMCDROM_THIS capacity = BX_FMCDROM_THIS cd->capacity();
	      } else {		    
		    BX_INFO(("Could not locate CD-ROM, continuing with media not present\n"));
	      }
	} else
#endif
	      BX_INFO(("Media not present in CD-ROM drive\n"));
  } else {
    BX_INFO(("Media not present in CD-ROM drive\n"));
  }
}
  // static IO port read callback handler
  // redirects to non-static class handler to avoid virtual functions

  Bit32u
bx_fmcdrom_c::read_handler(void *this_ptr, Bit32u address, unsigned io_len)
{
#if !BX_USE_FMCD_SMF
  bx_fmcdrom_c *class_ptr = (bx_fmcdrom_c *) this_ptr;

  return( class_ptr->read(address, io_len) );
}

  Bit32u
bx_fmcdrom_c::read(Bit32u address, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif
  Bit8u ret8;
  Bit32u ret = 0;
#define RETURN(x) do { ret = (x); goto read_return; } while (0)

  //  if (io_len > 1)
  //  BX_PANIC(("io read from address %08x len=%u\n",
  //          (unsigned) address, (unsigned) io_len);

  switch (address) {
    case 0x04c0:
      RETURN((BX_FMCDROM_THIS irq_from_submpu     ? 0x80 : 0x00) |
	     (BX_FMCDROM_THIS irq_end_dma         ? 0x40 : 0x00) |
	     (BX_FMCDROM_THIS soft_trans          ? 0x20 : 0x00) |
	     (BX_FMCDROM_THIS dma_trans           ? 0x10 : 0x00) |
	     (BX_FMCDROM_THIS status_read_request ? 0x02 : 0x00) |
	     (BX_FMCDROM_THIS ready               ? 0x01 : 0x00));

    case 0x04c2:
      if(BX_FMCDROM_THIS status_read_request) {
	ret8 = BX_FMCDROM_THIS status[BX_FMCDROM_THIS scount];
	BX_FMCDROM_THIS scount++;
	if(BX_FMCDROM_THIS scount >= 4) {
	  BX_FMCDROM_THIS status_read_request = 0;
	  if(BX_FMCDROM_THIS extra_status_exist) {
	    if(BX_FMCDROM_THIS command.type) {
	      switch(BX_FMCDROM_THIS command.code) {
	      default:
		break;
	      }
	    } else {
	      switch(BX_FMCDROM_THIS command.code) {
	      case 0: /* SEEK */
		BX_FMCDROM_THIS update_status(0x04,0x00,0x00,0x00);
		BX_FMCDROM_THIS extra_status_exist=0;
		break;
		
	      case 2: /* READ(MODE1) */
		bx_pc_system.activate_timer( BX_FMCDROM_THIS timer_handle, 0, 0);
		BX_FMCDROM_THIS extra_status_exist=0;
		break;

	      case 5: /* TOC READ */
		switch(BX_FMCDROM_THIS extra_status_count) {
		case 0:
		case 2:
		  BX_FMCDROM_THIS update_status(0x16,0x00,0x00,0x00);
		  break;
		case 1:
#ifdef LOWLEVEL_CDROM
		  int toclen;
		  BX_FMCDROM_THIS cd->read_toc(BX_FMCDROM_THIS buffer,
					       &toclen,true,0);
		  BX_FMCDROM_THIS update_status(0x17,bin2bcd(BX_FMCDROM_THIS buffer[2]),0x00,0x00);
		  //		  for(int i=0;i<1024;i++) {
		  //  BX_INFO(("%.4x %.2x\n",i,BX_FMCDROM_THIS buffer[i]));
		  //}
		  //abort();
#else
		  BX_FMCDROM_THIS update_status(0x10,0x00,0x00,0x00);
#endif
		  break;
		case 3:
		  BX_FMCDROM_THIS update_status(0x17,bin2bcd(BX_FMCDROM_THIS buffer[3]),0x00,0x00);
		  break;
		case 4:
		  BX_FMCDROM_THIS update_status(0x16,
						(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2]+1)*8+4+1]<<4) |
						(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2]+1)*8+4+1]>>4),
						0xaa,0x00);
		  break;
		case 5:
		  BX_FMCDROM_THIS update_status(0x17,
						bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2]+1)*8+4+5]),
						bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2]+1)*8+4+6]),
						bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2]+1)*8+4+7]));
		  break;
		default:
		  if((BX_FMCDROM_THIS extra_status_count&1)==0) {
		    BX_FMCDROM_THIS update_status(0x16,
						  (BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-6)/2*8+4+1]<<4) |
						  (BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-6)/2*8+4+1]>>4),
						  BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-6)/2*8+4+2],0x00);
		  } else {
		    BX_FMCDROM_THIS update_status(0x17,
						  bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-7)/2*8+4+5]),
						  bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-7)/2*8+4+6]),
						  bin2bcd(BX_FMCDROM_THIS buffer[(BX_FMCDROM_THIS extra_status_count-7)/2*8+4+7]));
		    if((BX_FMCDROM_THIS extra_status_count-7)/2>=(BX_FMCDROM_THIS buffer[3]-BX_FMCDROM_THIS buffer[2])) 
		      BX_FMCDROM_THIS extra_status_exist=0;
		  }
		  break;
		}
		BX_FMCDROM_THIS extra_status_count++;
		break;

	      default:
		break;
	      }
	    }
	  } else {
	    BX_FMCDROM_THIS ready               = 1;
	  }
	}
	RETURN(ret8);
      } else {
	BX_PANIC(("Status buffer empty!\n"));
      }

    default:
      BX_PANIC(("unsupported fmcdrom read, address=0x%.4x!\n",
        (unsigned) address));
      RETURN(0);
      break;
    }
  read_return:
  if (bx_dbg.fmcdrom)
    BX_INFO(("read from address: 0x%x = 0x%x\n",
      (unsigned) address, (unsigned) ret));
  return ret;
}
#undef RETURN


  // static IO port write callback handler
  // redirects to non-static class handler to avoid virtual functions

  void
bx_fmcdrom_c::write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len)
{
#if !BX_USE_FMCD_SMF
  bx_fmcdrom_c *class_ptr = (bx_fmcdrom_c *) this_ptr;

  class_ptr->write(address, value, io_len);
}

  void
bx_fmcdrom_c::write(Bit32u address, Bit32u value, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_FMCD_SMF
  int i;

  if (io_len > 1)
    BX_PANIC(("io write to address %08x len=%u\n",
	      (unsigned) address, (unsigned) io_len));

  if (bx_dbg.fmcdrom)
    BX_INFO(("write to address: 0x%x = 0x%x\n",
      (unsigned) address, (unsigned) value));

  switch (address) {
    case 0x04c0:
      if((value & 0x80) != 0) {
        BX_FMCDROM_THIS irq_from_submpu = 0;
      }
      if((value & 0x40) != 0) {
	BX_FMCDROM_THIS irq_end_dma     = 0;
      }
      if((value & 0x04) != 0) {
	BX_PANIC(("sub mpu reset.\n"));
      }
      BX_FMCDROM_THIS enable_irq_from_submpu = (value & 0x02) != 0;
      BX_FMCDROM_THIS enable_irq_end_dma     = (value & 0x01) != 0;
      BX_FMCDROM_THIS update_irq();
      return;

    case 0x04c4:
      for(i=0;i<7;i++) {
	BX_FMCDROM_THIS parameter[i] = BX_FMCDROM_THIS parameter[i+1];
      }
      BX_FMCDROM_THIS parameter[7] = value;
      return;

    case 0x04c2:
      BX_FMCDROM_THIS command.type   = (value & 0x80) != 0;
      BX_FMCDROM_THIS command.irq    = (value & 0x40) != 0;
      BX_FMCDROM_THIS command.status = (value & 0x20) != 0;
      BX_FMCDROM_THIS command.code   =  value & 0x1f;
      BX_FMCDROM_THIS extra_status_exist=0;
      BX_FMCDROM_THIS extra_status_count=0;
      BX_FMCDROM_THIS ready             =0;
      BX_FMCDROM_THIS readindex         =-1;
      if (bx_dbg.fmcdrom)
	BX_INFO(("command=0x%.2x, param=(0x%.2x,0x%.2x,0x%.2x,0x%.2x,0x%.2x,0x%.2x,0x%.2x,0x%.2x)\n",
		 value,
		 BX_FMCDROM_THIS parameter[0],
		 BX_FMCDROM_THIS parameter[1],
		 BX_FMCDROM_THIS parameter[2],
		 BX_FMCDROM_THIS parameter[3],
		 BX_FMCDROM_THIS parameter[4],
		 BX_FMCDROM_THIS parameter[5],
		 BX_FMCDROM_THIS parameter[6],
		 BX_FMCDROM_THIS parameter[7]));
      if(!BX_FMCDROM_THIS indisc) {
	BX_FMCDROM_THIS update_status(0x10,0x00,0x00,0x00);
	return;
      }
      if(BX_FMCDROM_THIS command.type) {
	switch(BX_FMCDROM_THIS command.code) {
	case 0: /* set state */
	  BX_FMCDROM_THIS update_status(0x00,0x00,0x00,0x00);
	  return;

	case 1: /* set state */
	  BX_INFO(("command CDDASET (not yet).\n"));
	  BX_FMCDROM_THIS update_status(0x00,0x00,0x00,0x00);
	  return;

	default:
	  BX_PANIC(("unsupported CD-ROM operation.\n"));
	}
      } else {
	switch(BX_FMCDROM_THIS command.code) {
	case 0: /* SEEK */
	  BX_FMCDROM_THIS update_status(0x00,0x00,0x00,0x00);
	  BX_FMCDROM_THIS extra_status_exist=1;
	  return;

	case 2: /* READ(MODE1) */
	  BX_FMCDROM_THIS next_lba =
	    bcd2bin(BX_FMCDROM_THIS parameter[0]) * 4500 +
	    bcd2bin(BX_FMCDROM_THIS parameter[1]) * 75 +
	    bcd2bin(BX_FMCDROM_THIS parameter[2]) - 150;
	  BX_FMCDROM_THIS last_lba =
	    bcd2bin(BX_FMCDROM_THIS parameter[3]) * 4500 +
	    bcd2bin(BX_FMCDROM_THIS parameter[4]) * 75 +
	    bcd2bin(BX_FMCDROM_THIS parameter[5]) - 150;
	  if(BX_FMCDROM_THIS next_lba>BX_FMCDROM_THIS last_lba) {
	    BX_FMCDROM_THIS update_status(0x01,0x00,0x00,0x00);
	    return;
	  } else {
	    BX_FMCDROM_THIS update_status(0x00,0x00,0x00,0x00);
	    BX_FMCDROM_THIS extra_status_exist=1;
	  }
	  return;

	case 5: /* TOC READ */
	  BX_FMCDROM_THIS update_status(0x00,0x00,0x00,0x00);
	  BX_FMCDROM_THIS extra_status_exist=1;
	  return;

	default:
	  BX_PANIC(("unsupported CD-ROM operation.\n"));
	}
      }
      return;

    case 0x04c6:
      BX_FMCDROM_THIS soft_trans_mode = (value & 0x08) != 0;
      if(BX_FMCDROM_THIS soft_trans_mode) {
	BX_PANIC(("software transfer mode.\n"));
      }
      BX_FMCDROM_THIS dma_trans_mode  = (value & 0x10) != 0;
      BX_FMCDROM_THIS update_dma();
      return;

    default:
      BX_PANIC(("unsupported fmcdrom write, address=0x%.4x!\n",
        (unsigned) address));
      return;
      break;
    }
}


  void
bx_fmcdrom_c::update_status(Bit8u st0, Bit8u st1, Bit8u st2, Bit8u st3)
{
  BX_INFO(("status = %.2x %.2x %.2x %.2x\n",st0,st1,st2,st3));
  if(BX_FMCDROM_THIS command.status) {
    BX_FMCDROM_THIS status[0]=st0;
    BX_FMCDROM_THIS status[1]=st1;
    BX_FMCDROM_THIS status[2]=st2;
    BX_FMCDROM_THIS status[3]=st3;
    BX_FMCDROM_THIS scount=0;
    BX_FMCDROM_THIS status_read_request=1;
    if(BX_FMCDROM_THIS command.irq) {
      BX_FMCDROM_THIS irq_from_submpu=1;
      BX_FMCDROM_THIS update_irq();
    }
  }
  return;
}


  void
bx_fmcdrom_c::update_irq(void)
{
  Boolean newirq;

  newirq=
    (BX_FMCDROM_THIS irq_from_submpu
     && BX_FMCDROM_THIS enable_irq_from_submpu) ||
    (BX_FMCDROM_THIS irq_end_dma
     && BX_FMCDROM_THIS enable_irq_end_dma);

  if(BX_FMCDROM_THIS irq9_raising) {
    if(!newirq) {
      BX_FMCDROM_THIS irq9_raising=0;
      BX_FMCDROM_THIS devices->pic->untrigger_irq(9);
    }
  } else {
    if(newirq) {
      BX_FMCDROM_THIS irq9_raising=1;
      BX_FMCDROM_THIS devices->pic->trigger_irq(9);
    }
  }
}


  void
bx_fmcdrom_c::update_dma(void)
{
  Boolean newdma;

  newdma = BX_FMCDROM_THIS readindex>=0 && BX_FMCDROM_THIS dma_trans_mode;
  if(BX_FMCDROM_THIS dma_trans) {
    if(!newdma) {
      BX_FMCDROM_THIS dma_trans=0;
      bx_pc_system.set_DRQ(3, 0);
    }
  } else {
    if(newdma) {
      BX_FMCDROM_THIS dma_trans=1;
      bx_pc_system.set_DRQ(3, 1);
    }
  }
}


  void
bx_fmcdrom_c::dma_write(Bit8u *data_byte)
{
  *data_byte = BX_FMCDROM_THIS buffer[BX_FMCDROM_THIS readindex];
  BX_FMCDROM_THIS readindex++;
  if(BX_FMCDROM_THIS readindex>=2048) {
    BX_FMCDROM_THIS readindex=-1;
    BX_FMCDROM_THIS soft_trans_mode=0;
    BX_FMCDROM_THIS dma_trans_mode=0;
    BX_FMCDROM_THIS irq_end_dma=1;
    BX_FMCDROM_THIS update_dma();
    BX_FMCDROM_THIS update_irq();
    bx_pc_system.activate_timer( BX_FMCDROM_THIS timer_handle, 0, 0);
  }
  return;
}


  void
bx_fmcdrom_c::dma_read(Bit8u *data_byte)
{
  BX_PANIC(("dma_read\n"));
}


  void
bx_fmcdrom_c::timer_handler(void *this_ptr)
{
  bx_fmcdrom_c *class_ptr = (bx_fmcdrom_c *) this_ptr;

  class_ptr->timer();
}


  void
bx_fmcdrom_c::timer(void)
{
  if(BX_FMCDROM_THIS command.type) {
    switch(BX_FMCDROM_THIS command.code) {
    default:
      BX_PANIC(("unsupported CD-ROM operation.\n"));
    }
  } else {
    switch(BX_FMCDROM_THIS command.code) {
    case 2: /* READ(MODE1) */
      if(BX_FMCDROM_THIS next_lba>BX_FMCDROM_THIS last_lba) {
	BX_FMCDROM_THIS update_status(0x06,0x00,0x00,0x00);
      } else {
#ifdef LOWLEVEL_CDROM
	if (bx_dbg.fmcdrom)
	  BX_INFO(("read_block 0x%.8x\n",BX_FMCDROM_THIS next_lba));
	BX_FMCDROM_THIS cd->read_block(BX_FMCDROM_THIS buffer,
				       BX_FMCDROM_THIS next_lba);
	BX_FMCDROM_THIS next_lba++;
	BX_FMCDROM_THIS readindex=0;
	BX_FMCDROM_THIS update_dma();
	BX_FMCDROM_THIS update_status(0x22,0x00,0x00,0x00);
#else
	BX_FMCDROM_THIS update_status(0x10,0x00,0x00,0x00);
#endif
      }
      break;

    default:
      BX_PANIC(("unsupported CD-ROM operation.\n"));
    }
  }
}
#endif
